;
; Virtual Disk Drive Project - March 22, 2002 - EJR (at home)
;

;
; short cut to include the right header file
;
#include "p16c74b.inc"


;
; Hardware Settings
;
#include "portdef.h"

;
; Memory
;
#include "memdef.h"

;
; Macros
;
#include "memory.mac"
#include "utility.mac"


;;;
;;; Simple Macros for use everywhere
;;;
;;;**********************************************************************
;;; NAME:	SkipAlways()
;;;
;;; DESCR:	Always skip the next instruction.  Used to eliminate the
;;;		unnecessary goto sometimes in macros. (makes life easier)
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- does simple static address incrementing
;;;**********************************************************************
SkipAlways:	macro
                goto	$ + 2
                endm


;;;**********************************************************************
;;; NAME:	InvertZ()
;;;
;;; DESCR:	Inverts the Z flag in status so that the next command
;;;		will operate on the inverse.  NOTE that this munges W.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	This works by:
;;;		  - moving a constant into W (which DOESN'T affect Z)
;;;                    that represents the Z position within STATUS
;;;		  - ANDing the constant with the STATUS register
;;;                   - if the result of the AND is zero, this means that
;;;                     the Z bit was NOT set, but since the result is
;;;			zero, the Z bit in status will be set
;;;                   - if the result of the AND is NOT zero, then the
;;;                     Z bit WAS set, but since the result of the AND
;;;                     is not zero, the Z bit in status will not be set.
;;;**********************************************************************
InvertZ:   macro
	   movlw	0x04		; Z position in Status (doesn't change Z itself)
	   andwf	STATUS,W	; flip the Z bit here
	   endm

;;;*******************************************************************
;;; NAME:	GotoPrevious()
;;;
;;; DESCR:	Jump to the previous line.  Used for monitoring loops.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************
GotoPrevious:	macro
                goto	$ - 1
                endm

   errorlevel -302		; stops banking warnings
   errorlevel -305		; stops default destination warnings
